	subroutine gensinus(nob,nextra,k,np,rho,phi,x)
c
c**********************************************************************
c
c   FORTRAN subroutine to generate a multivariate time series of 
c   length nob from a sinusoidal function.
c
c   Input: nob = an integer containing the length of the desired 
c              realization,
c          nextra = an integer containing the number of initial
c                   realizations,
c          k = an integer containing the number of time series
c              (e.g., k = 2 means a bivariate time series),
c          np = an integer containing the order of the process,
c          rho = a double precision real scalar containing the cross-
c                correlation between the error terms,
c          phi = a double precision np x k x k array containing the 
c                coefficients of the sinusoidal terms.
c
c   The subroutine gensinus returns a double precision matrix x 
c   of dimension nob x k containing the desired realization.
c
c   Created: 3/7/98 JLH
c
c   Subprograms called (IMSL): DCHFAC, DRNMVN, DMACH
c
c**********************************************************************
c
	parameter (nkmx = 5, nmx = 2500, npmx = 5)
	parameter (nqmx = (npmx*nkmx)**2)
	implicit double precision (a-h, p-z)
c
	integer nob,np,nextra,k
c
	double precision cov(nkmx,nkmx),eps(nmx,nkmx),x(nmx,nkmx)
	double precision phi(npmx,nkmx,nkmx)
c
c	external DCHFAC, DRNMVN, DMACH
c
c   Initialize matrices and constants:
c
	do i = 1,nmx
	do j = 1,nkmx
	   eps(i,j) = 0.0d0
	enddo
	enddo
c
c   Set covariance matrix (cov):
c
	do i = 1,k
	do j = 1,k
	   if(i.eq.j) then
	      cov(i,j) = 1.0d0
	   else
	      cov(i,j) = rho
	   endif
	enddo
	enddo
c
c   Use IMSL subroutines.
c
c   The subroutine DCHFAC computes an upper triangular factorization of 
c   a real symmetric nonnegative definite matrix.  The result is returned
c   in the matrix cov.
c
c   The subroutine DRNMVN generates pseudorandom numbers from a 
c   multivariate normal distribution.  The result is returned in the
c   vector eps.
c
	call DCHFAC(k,cov,nkmx,100.0d0*DMACH(4),irank,cov,nkmx)
	call DRNMVN(nob+nextra,k,cov,nkmx,eps,nmx)
c
c   Generate data from linear vector autoregressive process:
c
	do i = 1,nob+nextra
	   do ii = 1,k	
	      x(i,ii) = dcos(eps(i,ii))
	   enddo
	   do j = 1,min(i-1,np)
	      do l = 1,k
	      do m = 1,k
		 x(i,l) = x(i,l) + phi(j,l,m)*dcos(x(i-j,m))
	      enddo
	      enddo
	   enddo
	enddo
c
	do i = 1,nob
	do j = 1,k
	   x(i,j) = x(i+nextra,j)
	enddo
	enddo
c
	return
	end
